<?php

/*
 *      lib.php
 *      
 *      Copyright 2009 Jaroslaw Czarniak <jaroslaw@czarniak.org>
 *      
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation; either version 2 of the License, or
 *      (at your option) any later version.
 *      
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 *      
 *      You should have received a copy of the GNU General Public License
 *      along with this program; if not, write to the Free Software
 *      Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 *      MA 02110-1301, USA.
 *	       
 *	
 *	 
 */

function array_sort_by_fields(&$data, $sortby)
{
      static $sort_funcs = array();
     
    if (empty($sort_funcs[$sortby]))
    {
        $code = "\$c=0;";
        foreach (split(',', $sortby) as $key)
        {
           $d = '1';
              if (substr($key, 0, 1) == '-')
              {
                 $d = '-1';
                 $key = substr($key, 1);
              }
              if (substr($key, 0, 1) == '#')
              {
                 $key = substr($key, 1);
               $code .= "if ( ( \$c = (\$a['$key'] - \$b['$key'])) != 0 ) return $d * \$c;\n";
              }
              else
              {
               $code .= "if ( (\$c = strcasecmp(\$a['$key'],\$b['$key'])) != 0 ) return $d * \$c;\n";
            }
        }
        $code .= 'return $c;';
        $sort_func = $sort_funcs[$sortby] = create_function('$a, $b', $code);
    }
    else
    {
        $sort_func = $sort_funcs[$sortby];
    }   
    uasort($data, $sort_func);   
}

class Guestbook{

      // database object
      var $sql = null;
      // smarty template object
      var $tpl = null;
      // error messages
      var $error = null;


function Guestbook() 
{

      // instantiate the sql object
      $this->sql =& new GuestBook_SQL;
      // instantiate the template object
      $this->tpl =& new Guestbook_Smarty;


}
function sqlQ($sql = array())
{
      //obsluga zapytania
      $this->sql->query($sql,SQL_ALL,SQL_ASSOC);
      return $this->sql->record;
}

///////////////////////////////////////////////////

function szukaj($szukaj)
{
      //ustawienie zmiennej sesyjne do wyszukiwania
      session_start();
      $_SESSION['szukaj']=$szukaj;
}

function redirect($link)
{
      //przekierowanie pod wskazany adres
      echo "<SCRIPT>\n";
      echo "<!--\n";
      echo "  var version = parseInt(navigator.appVersion)\n";
      echo "  if (version>=4 || window.location.replace)\n";
      echo "    window.location.replace(\"".$link."\")\n";
      echo "  else\n";
      echo "    window.location.href = \"".$link."\" \n";
      echo "// -->\n";
      echo "</SCRIPT>\n";
}	
function sort($sortby,$order)
{
      //sortowanie wg przekazanych kolumn
      session_start();
      $_SESSION['sortby']=$sortby;
      $_SESSION['order']=$order;
}

function filtruj($typ,$temperament,$wielkosc_od,$wielkosc_do,$dieta,$temperatura,$temperatura_max,$trudnosc)
{
      //filtrowanie po typach
      session_start();
      $_SESSION['filtruj']['typ']=$typ;
      $_SESSION['filtruj']['temperament']=$temperament;
      if ($wielkosc_od!=''){$_SESSION['filtruj']['wielkosc_od']=$wielkosc_od;}
      if ($wielkosc_do!=''){$_SESSION['filtruj']['wielkosc_do']=$wielkosc_do;}
      if ($dieta){$_SESSION['filtruj']['dieta']=$dieta;}
//      else {$_SESSION['filtruj']['dieta']=0;}
      if ($temperatura!=''){$_SESSION['filtruj']['temperatura']=$temperatura;}
      if ($temperatura_max!=''){$_SESSION['filtruj']['temperatura_max']=$temperatura_max;}
      if ($trudnosc){$_SESSION['filtruj']['trudnosc']=$trudnosc;}
}


function showlist($szukaj,$login,$admin,$filtruj)
{
      //wyswietlenie danych
      //rozpoczecie sesji
      session_start();
      if (!$_SESSION['sort_arg']){$_SESSION['sort_arg']='nazwa';}
      if (!$_SESSION['sort_order']){$_SESSION['sort_order']='asc';}

//      echo '|'.$filtruj['trudnosc'].'|';
      //ustawienie kodowania
    	    $filtruj=$_SESSION['filtruj'];
	    $this->sql->query('SET CHARACTER SET utf8;');
	    	    
	    $query_pre="
	    SELECT distinct g.id, g.typ, g.nazwa, g.nazwa_powsz, g.pochodzenie, s.nazwa as srodowisko, g.dieta, g.plec, g.rozmnazanie, g.temperament, g.widoczny_temperament, g.wielkosc, g.temperatura, 
	    g.temperatura_max, g.ph, g.twardosc, g.trudnosc, t.nazwa as typ_nazwa, f.foto_id
	    FROM gatunki g 
	    INNER JOIN typy t ON g.typ=t.id 
	    LEFT OUTER JOIN foto f ON f.gatunek_id=g.id
	    INNER JOIN srodowisko s ON g.srodowisko=s.id
	    WHERE 1 ";
	    if ($szukaj){$query_pre.="AND g.nazwa LIKE '%".$szukaj."%' ";}
	    if ($filtruj['temperament']){$query_pre.="AND g.temperament LIKE '".$filtruj['temperament']."%' ";}
	    if ($filtruj['typ']){$query_pre.="AND g.typ LIKE '%".$filtruj['typ']."%' ";}
	    if ($filtruj['wielkosc_od']){$query_pre.="AND g.wielkosc >= ".$filtruj['wielkosc_od']." ";}
	    if ($filtruj['wielkosc_do']){$query_pre.="AND g.wielkosc <= ".$filtruj['wielkosc_do']." ";}
	    if ($filtruj['dieta']=='RosWsz'){$query_pre.="AND (g.dieta LIKE 'Rośli%' OR g.dieta LIKE 'Wszystko%') ";}
	    elseif ($filtruj['dieta']=='MieWsz'){$query_pre.="AND (g.dieta LIKE 'Mięso%' OR g.dieta LIKE 'Wszystko%') ";}
	    elseif ($filtruj['dieta']!='All' && $filtruj['dieta']!=''){$query_pre.="AND g.dieta LIKE '%".$filtruj['dieta']."%' ";}
	    
	    if ($filtruj['temperatura']){$query_pre.="AND g.temperatura_max >= ".$filtruj['temperatura']." "."AND g.temperatura <= ".$filtruj['temperatura']." ";}
	    if ($filtruj['temperatura_max']){$query_pre.="AND g.temperatura <= ".$filtruj['temperatura_max']." "."AND g.temperatura_max >= ".$filtruj['temperatura_max']." ";}
	    if ($filtruj['trudnosc']!='All' && $filtruj['trudnosc']!=''){$query_pre.="AND g.trudnosc = ".$filtruj['trudnosc']." ";}
	    
	    $query_pre.="GROUP BY g.id, g.typ, g.nazwa, g.nazwa_powsz, g.pochodzenie, g.srodowisko, g.dieta, g.plec, g.rozmnazanie, g.temperament, g.widoczny_temperament, g.wielkosc, g.temperatura, g.temperatura_max, g.ph, g.twardosc, g.trudnosc, t.nazwa ";
	    
	    
	    if ($_SESSION['sort_arg']=='nazwa') {$query_pre.="ORDER BY g.nazwa ";}
	    if ($_SESSION['sort_arg']=='wielkosc') {$query_pre.="ORDER BY g.wielkosc ";}
	    if ($_SESSION['sort_arg']=='temperatura') {$query_pre.="ORDER BY g.temperatura ";}
	    if ($_SESSION['sort_arg']=='ph') {$query_pre.="ORDER BY g.ph ";}
	    if ($_SESSION['sort_arg']=='trudnosc') {$query_pre.="ORDER BY g.trudnosc ";}
	    if ($_SESSION['sort_arg']=='temperament') {$query_pre.="ORDER BY g.temperament ";}

	    if ($_SESSION['sort_order']=='asc') {$query_pre.="ASC ";}
	    if ($_SESSION['sort_order']=='desc') {$query_pre.="DESC ";}
	    
	    $query_pre.=" ;";
//	    echo $query_pre;
            $data=$this->sqlQ($query_pre);


            $query_pre="SELECT count(id) as liczba FROM gatunki_moderacja;";
	    $liczba_tmp=mysql_query($query_pre);
	    
	    while ($row = mysql_fetch_assoc($liczba_tmp))
            {    
                  $liczba_mod=$row;
            }



            $query_pre="SELECT * from typy;";
	    $typy_tmp=mysql_query($query_pre);
	    
	    while ($row = mysql_fetch_assoc($typy_tmp))
            {    
                  $typy[]=$row;
            }


            $query_pre="SELECT DISTINCT (temperament) as temperament FROM gatunki;";
	    $typy_tmp=mysql_query($query_pre);
	    
	    while ($row = mysql_fetch_assoc($typy_tmp))
            {    
                  $temperamenty[]=$row;
            }

            $query_pre="SELECT DISTINCT (dieta) as dieta FROM gatunki;";
	    $typy_tmp=mysql_query($query_pre);
	    
	    while ($row = mysql_fetch_assoc($typy_tmp))
            {    
                  $diety[]=$row;
            }
      
//      $this->tpl->debugging = true;
//      $this->tpl->assign('error', $this->error);
      
      $this->tpl->assign('szukaj',$szukaj);
      $this->tpl->assign('login',$login);
      $this->tpl->assign('admin',$admin);
      $this->tpl->assign('filtruj',$filtruj);
      $this->tpl->assign('SORTBY',$_SESSION['sortby']);
      $this->tpl->assign('ORDER',$_SESSION['order']);
      $this->tpl->assign('liczba_mod',$liczba_mod['liczba']);
      $this->tpl->assign('data', $data);
      $this->tpl->assign('typy', $typy);
      $this->tpl->assign('temperamenty', $temperamenty);
      $this->tpl->assign('diety', $diety);
      $this->tpl->assign('sort_unorder',$_SESSION['sort_unorder']);
      $this->tpl->assign('sort_arg',$_SESSION['sort_arg']);
      $this->tpl->display('list.tpl');

}

function show_fish_old($id,$login)
{
	    $this->sql->query('SET CHARACTER SET utf8;');
            $query_pre=" 
	    SELECT g.id, g.typ, g.nazwa, g.nazwa_powsz, g.pochodzenie, s.nazwa AS srodowisko, g.dieta, g.plec, g.rozmnazanie, g.temperament, g.widoczny_temperament, g.wielkosc, g.temperatura, g.temperatura_max, g.ph, g.twardosc, g.trudnosc
	    FROM gatunki g
	    INNER JOIN srodowisko s ON g.srodowisko = s.id
	    where g.id=".$id." ;";
            $dane=$this->sqlQ($query_pre);

	    $query_pre="select foto_id,foto_desc from foto where gatunek_id=".$id.";";
	    $foto_tmp=mysql_query($query_pre);
	    while ($row = mysql_fetch_assoc($foto_tmp))
            {    
		if (substr($row['foto_id'],0,2)=='d/'){$serwer='http://album.klub-malawi.pl/';}
		if (substr($row['foto_id'],0,2)=='da'){$serwer='http://galeria.klub-malawi.pl/';}
		$link=$serwer.$row['foto_id'];
//		echo $link.'<BR>';
		  $size = getimagesize($link);
		  if ($size['0']>450)
		    {
			$size['1']=$size['1']*(600/$size['0']);
			$size['0']=600;
		    }
		  if ($size['1']>390)
		    {
			$size['0']=$size['0']*(390/$size['1']);
			$size['1']=390;
		    }


//print_r($size);
                  $foto[]=array_merge($row,$size);
//                  $foto[]=$row;
            }

	    $query_pre="select komentarz,login from komentarze where gatunek_id=".$id.";";
	    $komentarz_tmp=mysql_query($query_pre);
	    while ($row = mysql_fetch_assoc($komentarz_tmp))
            {    
                  $komentarze[]=$row;
            }

	    $query_pre="select link from artykuly where gatunek_id=".$id.";";
	    $art_tmp=mysql_query($query_pre);
	    while ($row = mysql_fetch_assoc($art_tmp))
            {    
                  $artykuly[]=$row;
            }

	    $typ = $dane[0][typ];
	    $nazwa = $dane[0][nazwa];
	    $nazwa_powsz = $dane[0][nazwa_powsz];
	    $pochodzenie = $dane[0][pochodzenie];
	    $srodowisko = $dane[0][srodowisko];
	    $dieta = $dane[0][dieta];
	    $plec = $dane[0][plec];
	    $rozmnazanie = $dane[0][rozmnazanie];
	    $temperament = $dane[0][temperament];
	    $widoczny_temperament = $dane[0][widoczny_temperament];
	    $wielkosc = $dane[0][wielkosc];
	    $temperatura = $dane[0][temperatura];
	    $temperatura_max = $dane[0][temperatura_max];
	    $ph = $dane[0][ph];
	    $twardosc = $dane[0][twardosc];
	    $trudnosc = $dane[0][trudnosc];


//      $this->tpl->debugging = true;
//      $this->tpl->assign('error', $this->error);
            
            if ($_SESSION['wiadomosc'])
            {
                  $this->tpl->assign('wiadomosc', $_SESSION['wiadomosc']);
                  $_SESSION['wiadomosc']='';
            }
            
    	    $this->tpl->assign('id', $id);
	    $this->tpl->assign('login', $login);
    	    $this->tpl->assign('typ', $typ);
	    $this->tpl->assign('nazwa', $nazwa);
	    $this->tpl->assign('nazwa_powsz', $nazwa_powsz);
	    $this->tpl->assign('pochodzenie', $pochodzenie);
	    $this->tpl->assign('srodowisko', $srodowisko);
	    $this->tpl->assign('dieta', $dieta);
	    $this->tpl->assign('plec', $plec);
            $this->tpl->assign('rozmnazanie', $rozmnazanie);
	    $this->tpl->assign('temperament', $temperament);
	    $this->tpl->assign('widoczny_temperament', $widoczny_temperament);
	    $this->tpl->assign('wielkosc', $wielkosc);
	    $this->tpl->assign('temperatura', $temperatura);
	    $this->tpl->assign('temperatura_max', $temperatura_max);
	    $this->tpl->assign('ph', $ph);
	    $this->tpl->assign('twardosc', $twardosc);
	    $this->tpl->assign('trudnosc', $trudnosc);
	    $this->tpl->assign('foto', $foto);
	    $this->tpl->assign('komentarze', $komentarze);
	    $this->tpl->assign('artykuly', $artykuly);

	    $this->tpl->assign('czy_admin',$_SESSION['admin'] );
	    $this->tpl->assign('czy_klubowicz', $_SESSION['klubowicz']);
	    
	    $this->tpl->display('show_fish.tpl');
}



function show_fish($id,$login)
{
	    $this->sql->query('SET CHARACTER SET utf8;');
            $query_pre=" 
	    SELECT g.id, g.typ, g.nazwa, g.nazwa_powsz, g.pochodzenie, s.nazwa AS srodowisko, g.dieta, g.plec, g.rozmnazanie, g.temperament, g.widoczny_temperament, g.wielkosc, g.temperatura, g.temperatura_max, g.ph, g.twardosc, g.trudnosc
	    FROM gatunki g
	    INNER JOIN srodowisko s ON g.srodowisko = s.id
	    where g.id=".$id." ;";
            $dane=$this->sqlQ($query_pre);

	    $query_pre="select foto_id,foto_desc,id from foto where gatunek_id=".$id.";";
	    $foto_tmp=mysql_query($query_pre);
	    while ($row = mysql_fetch_assoc($foto_tmp))
            {    
		if (substr($row['foto_id'],0,2)=='d/'){$serwer='http://album.klub-malawi.pl/';}
		if (substr($row['foto_id'],0,2)=='da'){$serwer='http://galeria.klub-malawi.pl/';}
		$link=$serwer.$row['foto_id'];
//		echo $link.'<BR>';
		  $size = getimagesize($link);
		  if ($size['0']>450)
		    {
			$size['1']=$size['1']*(600/$size['0']);
			$size['0']=600;
		    }
		  if ($size['1']>390)
		    {
			$size['0']=$size['0']*(390/$size['1']);
			$size['1']=390;
		    }


//print_r($size);
                  $foto[]=array_merge($row,$size);
//                  $foto[]=$row;
            }

	    $query_pre="select komentarz,login from komentarze where gatunek_id=".$id.";";
	    $komentarz_tmp=mysql_query($query_pre);
	    while ($row = mysql_fetch_assoc($komentarz_tmp))
            {    
                  $komentarze[]=$row;
            }

	    $query_pre="select link from artykuly where gatunek_id=".$id.";";
	    $art_tmp=mysql_query($query_pre);
	    while ($row = mysql_fetch_assoc($art_tmp))
            {    
                  $artykuly[]=$row;
            }

	    $typ = $dane[0][typ];
	    $nazwa = $dane[0][nazwa];
	    $nazwa_powsz = $dane[0][nazwa_powsz];
	    $pochodzenie = $dane[0][pochodzenie];
	    $srodowisko = $dane[0][srodowisko];
	    $dieta = $dane[0][dieta];
	    $plec = $dane[0][plec];
	    $rozmnazanie = $dane[0][rozmnazanie];
	    $temperament = $dane[0][temperament];
	    $widoczny_temperament = $dane[0][widoczny_temperament];
	    $wielkosc = $dane[0][wielkosc];
	    $temperatura = $dane[0][temperatura];
	    $temperatura_max = $dane[0][temperatura_max];
	    $ph = $dane[0][ph];
	    $twardosc = $dane[0][twardosc];
	    $trudnosc = $dane[0][trudnosc];


//      $this->tpl->debugging = true;
//      $this->tpl->assign('error', $this->error);
            
            if ($_SESSION['wiadomosc'])
            {
                  $this->tpl->assign('wiadomosc', $_SESSION['wiadomosc']);
                  $_SESSION['wiadomosc']='';
            }
            
    	    $this->tpl->assign('id', $id);
	    $this->tpl->assign('login', $login);
    	    $this->tpl->assign('typ', $typ);
	    $this->tpl->assign('nazwa', $nazwa);
	    $this->tpl->assign('nazwa_powsz', $nazwa_powsz);
	    $this->tpl->assign('pochodzenie', $pochodzenie);
	    $this->tpl->assign('srodowisko', $srodowisko);
	    $this->tpl->assign('dieta', $dieta);
	    $this->tpl->assign('plec', $plec);
            $this->tpl->assign('rozmnazanie', $rozmnazanie);
	    $this->tpl->assign('temperament', $temperament);
	    $this->tpl->assign('widoczny_temperament', $widoczny_temperament);
	    $this->tpl->assign('wielkosc', $wielkosc);
	    $this->tpl->assign('temperatura', $temperatura);
	    $this->tpl->assign('temperatura_max', $temperatura_max);
	    $this->tpl->assign('ph', $ph);
	    $this->tpl->assign('twardosc', $twardosc);
	    $this->tpl->assign('trudnosc', $trudnosc);
	    $this->tpl->assign('foto', $foto);
	    $this->tpl->assign('komentarze', $komentarze);
	    $this->tpl->assign('artykuly', $artykuly);

	    $this->tpl->assign('czy_admin',$_SESSION['admin'] );
	    $this->tpl->assign('czy_klubowicz', $_SESSION['klubowicz']);
	    
	    $this->tpl->display('show_fish.tpl');
}



function show_edytuj($id)
{

	    // DANE
	    $this->sql->query('SET CHARACTER SET utf8;');
//            $query_pre=" 
//	    SELECT g.id, g.typ, g.nazwa, g.nazwa_powsz, g.pochodzenie, s.nazwa AS srodowisko, g.dieta, g.plec, g.rozmnazanie, g.temperament, g.widoczny_temperament, g.wielkosc, g.temperatura, g.ph, g.twardosc, g.trudnosc 
//	    FROM gatunki g
//	    INNER JOIN srodowisko s ON g.srodowisko = s.id
//	    where g.id=".$id." ;";
            $query_pre=" 
	    SELECT * 
	    FROM gatunki g
	    where g.id=".$id." ;";
            $dane=$this->sqlQ($query_pre);

	    //SRODOWISKA
            $query_pre=" 
	    SELECT * 
	    FROM srodowisko;";
            $srodowiska=$this->sqlQ($query_pre);

	    //DIETY
            $query_pre=" 
	    SELECT distinct dieta 
	    FROM gatunki;";
            $diety=$this->sqlQ($query_pre);

	    //PŁCIE
            $query_pre=" 
	    SELECT distinct plec 
	    FROM gatunki;";
            $plcie=$this->sqlQ($query_pre);

	    //ROZMNAZANIA
            $query_pre=" 
	    SELECT distinct rozmnazanie
	    FROM gatunki;";
            $rozmnazania=$this->sqlQ($query_pre);

	    //TEMPERAMENTY
            $query_pre=" 
	    SELECT distinct temperament
	    FROM gatunki;";
            $temperamenty=$this->sqlQ($query_pre);

	    //TEMPERAMENTY WEWN
            $query_pre=" 
	    SELECT distinct widoczny_temperament
	    FROM gatunki;";
            $temperamenty_wew=$this->sqlQ($query_pre);

	    //TWARDOSCI
            $query_pre=" 
	    SELECT distinct twardosc
	    FROM gatunki;";
            $twardosci=$this->sqlQ($query_pre);

	    //TRUDNOSCI
            $query_pre=" 
	    SELECT distinct trudnosc
	    FROM gatunki;";
            $trudnosci=$this->sqlQ($query_pre);
	    
	    
	    //ZDJECIA
	    $query_pre="select foto_id,foto_desc from foto where gatunek_id=".$id.";";
	    $foto_tmp=mysql_query($query_pre);
	    
	    while ($row = mysql_fetch_assoc($foto_tmp))
            {    
                  $foto[]=$row;
            }

//            $foto=$this->sqlQ($query_pre);
//print_r($foto);
//break;
	    $typ = $dane[0][typ];
	    $nazwa = $dane[0][nazwa];
	    $nazwa_powsz = $dane[0][nazwa_powsz];
	    $pochodzenie = $dane[0][pochodzenie];
	    $srodowisko = $dane[0][srodowisko];
	    $dieta = $dane[0][dieta];
	    $plec = $dane[0][plec];
	    $rozmnazanie = $dane[0][rozmnazanie];
	    $temperament = $dane[0][temperament];
	    $widoczny_temperament = $dane[0][widoczny_temperament];
	    $wielkosc = $dane[0][wielkosc];
	    $temperatura = $dane[0][temperatura];
	    $temperatura_max = $dane[0][temperatura_max];
	    $ph = $dane[0][ph];
	    $twardosc = $dane[0][twardosc];
	    $trudnosc = $dane[0][trudnosc];


//      $this->tpl->debugging = true;
//      $this->tpl->assign('error', $this->error);

    	    $this->tpl->assign('id', $id);
    	    $this->tpl->assign('typ', $typ);
	    $this->tpl->assign('nazwa', $nazwa);
	    $this->tpl->assign('nazwa_powsz', $nazwa_powsz);
	    $this->tpl->assign('pochodzenie', $pochodzenie);
	    $this->tpl->assign('srodowisko', $srodowisko);
	    $this->tpl->assign('srodowiska', $srodowiska);
	    $this->tpl->assign('dieta', $dieta);
	    $this->tpl->assign('diety', $diety);
	    $this->tpl->assign('plec', $plec);
	    $this->tpl->assign('plcie', $plcie);
            $this->tpl->assign('rozmnazanie', $rozmnazanie);
	    $this->tpl->assign('rozmnazania', $rozmnazania);
	    $this->tpl->assign('temperament', $temperament);
	    $this->tpl->assign('temperamenty', $temperamenty);
	    $this->tpl->assign('widoczny_temperament', $widoczny_temperament);
	    $this->tpl->assign('temperamenty_wew', $temperamenty_wew);
	    $this->tpl->assign('wielkosc', $wielkosc);
	    $this->tpl->assign('temperatura', $temperatura);
	    $this->tpl->assign('temperatura_max', $temperatura_max);
	    $this->tpl->assign('ph', $ph);
	    $this->tpl->assign('twardosc', $twardosc);
	    $this->tpl->assign('twardosci', $twardosci);
	    $this->tpl->assign('trudnosc', $trudnosc);
	    $this->tpl->assign('trudnosci', $trudnosci);
	    $this->tpl->assign('foto', $foto);
	    $this->tpl->display('show_edytuj.tpl');
}

function dodaj_fish_show()
{
	    // DANE
	    $this->sql->query('SET CHARACTER SET utf8;');

	    //TYPY
            $query_pre=" 
	    SELECT * 
	    FROM typy;";
            $typy=$this->sqlQ($query_pre);

	    //SRODOWISKA
            $query_pre=" 
	    SELECT * 
	    FROM srodowisko order by nazwa desc;";
            $srodowiska=$this->sqlQ($query_pre);

	    //DIETY
            $query_pre=" 
	    SELECT distinct dieta 
	    FROM gatunki;";
            $diety=$this->sqlQ($query_pre);

	    //PŁCIE
            $query_pre=" 
	    SELECT distinct plec 
	    FROM gatunki;";
            $plcie=$this->sqlQ($query_pre);

	    //ROZMNAZANIA
            $query_pre=" 
	    SELECT distinct rozmnazanie
	    FROM gatunki;";
            $rozmnazania=$this->sqlQ($query_pre);

	    //TEMPERAMENTY
            $query_pre=" 
	    SELECT distinct temperament
	    FROM gatunki;";
            $temperamenty=$this->sqlQ($query_pre);

	    //TEMPERAMENTY WEWN
            $query_pre=" 
	    SELECT distinct widoczny_temperament
	    FROM gatunki order by widoczny_temperament ;";
            $temperamenty_wew=$this->sqlQ($query_pre);

	    //TWARDOSCI
            $query_pre=" 
	    SELECT distinct twardosc
	    FROM gatunki;";
            $twardosci=$this->sqlQ($query_pre);

	    //TRUDNOSCI
            $query_pre=" 
	    SELECT distinct trudnosc
	    FROM gatunki order by trudnosc;";
            $trudnosci=$this->sqlQ($query_pre);


//            $this->tpl->debugging = true;
//    	    $this->tpl->assign('error', $this->error);

    	    $this->tpl->assign('typy', $typy);
	    $this->tpl->assign('diety', $diety);
	    $this->tpl->assign('plcie', $plcie);
	    $this->tpl->assign('rozmnazania', $rozmnazania);
	    $this->tpl->assign('temperamenty', $temperamenty);
	    $this->tpl->assign('widoczny_temperament', $widoczny_temperament);
	    $this->tpl->assign('temperamenty_wew', $temperamenty_wew);
	    $this->tpl->assign('twardosci', $twardosci);
	    $this->tpl->assign('trudnosci', $trudnosci);

	    $this->tpl->assign('srodowiska', $srodowiska);
	    $this->tpl->display('dodaj_fish_show.tpl');
}

function dodaj_fish($ryba)
{
    $query_pre="INSERT INTO `gatunki` (id,typ,nazwa, nazwa_powsz,pochodzenie,srodowisko,dieta,plec,rozmnazanie,temperament,widoczny_temperament,wielkosc,temperatura,temperatura_max,ph,twardosc,trudnosc) VALUES (NULL,'".
	$ryba['typ']."','".$ryba['nazwa']."','".$ryba['nazwa_powsz']."','".$ryba['pochodzenie']."','".$ryba['srodowisko']."','".$ryba['dieta']."','".$ryba['plec']."','".
	$ryba['rozmnazanie']."','".$ryba['temperament']."','".$ryba['widoczny_temperament']."', '".$ryba['wielkosc']."','".$ryba['temperatura']."','".$ryba['temperatura_max']."','".$ryba['ph'].
	"','".$ryba['twardosc']."','".$ryba['trudnosc']."');";
        $this->sql->query('SET CHARACTER SET utf8;');
        $tmp=mysql_query($query_pre);

}

function edytuj($id,$typ,$nazwa,$nazwa_powsz, $pochodzenie, $srodowisko, $dieta, $plec, $rozmnazanie, $temperament, $widoczny_temperament, $wielkosc, $temperatura, $ph, $twardosc, $trudnosc,$login,$admin,$temperatura_max)
{
//    echo $id;
//    echo $nazwa;
//    echo $nazwa_powsz;
//    echo $pochodzenie;
//    echo $srodowisko;
//    echo $dieta;
//    echo $plec;
//    echo $rozmnazanie;
//    echo $temperament;
//    echo $widoczny_temperament;
//    echo $wielkosc;
//    echo $temperatura;
//    echo $ph;
//    echo $twardosc;
//    echo $trudnosc;
//    echo '<BR><BR>';

if ($login)
{
    if ($admin==1)
    {
        $query_pre="UPDATE `gatunki` set
	nazwa='".$nazwa."', 
	nazwa_powsz='".$nazwa_powsz."', 
	pochodzenie='".$pochodzenie."', 
	srodowisko='".$srodowisko."', 
	dieta='".$dieta."', 
	plec='".$plec."', 
	rozmnazanie='".$rozmnazanie."', 
	temperament='".$temperament."', 
	widoczny_temperament='".$widoczny_temperament."', 
	wielkosc='".$wielkosc."', 
	temperatura='".$temperatura."', 
	temperatura_max='".$temperatura_max."', 
	ph='".$ph."', 
	twardosc='".$twardosc."', 
	trudnosc='".$trudnosc."'
	WHERE id='".$id."'
	;";
    }
    elseif ($admin==0)
    {
        $query_pre="INSERT INTO `gatunki_moderacja` (id,typ,nazwa, nazwa_powsz,pochodzenie,srodowisko,dieta,plec,rozmnazanie,temperament,widoczny_temperament,wielkosc,temperatura,temperatura_max, 
	ph,twardosc,trudnosc) VALUES (".$id.",'".$typ."','".$nazwa."','".$nazwa_powsz."','".$pochodzenie."','".$srodowisko."','".$dieta."','".$plec."','".$rozmnazanie."','".$temperament."','".$widoczny_temperament."', 
	'".$wielkosc."','".$temperatura."','".$temperatura_max."','".$ph."','".$twardosc."','".$trudnosc."');";
	$_SESSION['wiadomosc']= "Przekazano zmianę do akceptacji.";
    }
	
	
	
//    echo $query_pre2;
        $this->sql->query('SET CHARACTER SET utf8;');
        $tmp=mysql_query($query_pre);

//	break;
}
}


function dodaj_show($id)
{
    $this->tpl->assign('id', $id);
      //wyswietlenie formatki dodania zdjecia
      $this->tpl->display('dodaj_foto.tpl');

}

function usun_foto($id)
{
	    $query_pre="delete from foto where id=".$id.";";
//	    echo $query_pre;
	    $foto_tmp=mysql_query($query_pre);

    echo '<SCRIPT LANGUAGE="JavaScript">
	    window.opener.location.href = window.opener.location.href;
	    self.close();
	  </script>';

}

function usun_foto_show($id)
{
	    $query_pre="select foto_id,foto_desc,id from foto where gatunek_id=".$id.";";
	    $foto_tmp=mysql_query($query_pre);
	    while ($row = mysql_fetch_assoc($foto_tmp))
            {    
		if (substr($row['foto_id'],0,2)=='d/'){$serwer='http://album.klub-malawi.pl/';}
		if (substr($row['foto_id'],0,2)=='da'){$serwer='http://galeria.klub-malawi.pl/';}
		$link=$serwer.$row['foto_id'];

		  $size = getimagesize($link);
		  if ($size['0']>450)
		    {
			$size['1']=$size['1']*(600/$size['0']);
			$size['0']=600;
		    }
		  if ($size['1']>390)
		    {
			$size['0']=$size['0']*(390/$size['1']);
			$size['1']=390;
		    }

                  $foto[]=array_merge($row,$size);
            }
//            $this->tpl->debugging = true;
//    	    $this->tpl->assign('error', $this->error);


	    $this->tpl->assign('foto', $foto);
	    $this->tpl->assign('link', $link);
	    $this->tpl->display('usun_foto.tpl');
}

function dodaj_foto($id,$link)
{

    if (strpos($link,'album.klub-malawi.pl'))
    {
        $this->sql->query('SET CHARACTER SET utf8;');
        $curl = curl_init();
	curl_setopt($curl, CURLOPT_URL, "$link");
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
        $strona = curl_exec($curl);
        curl_close($curl);
                
        $pos_start1 = strpos($strona, 'ImageFrame_shadow');
        $pos_start2 = strpos($strona, '<img src=', $pos_start1)+10;
        $pos_end2 = strpos($strona, 'width', $pos_start2);
        $plik = substr($strona,$pos_start2+1,$pos_end2-$pos_start2-3 ); 
//	    echo $plik;
    
        $pos_start1 = strpos($strona, 'giDescription')+15;
        $pos_start2 = strpos($strona, '<h2>', $pos_start1)+5;
        $pos_end1 = strpos($strona, '</h2>', $pos_start2);
        $opis = substr($strona,$pos_start2,$pos_end1-$pos_start2-1);
//	    echo $opis;
//        break;
        
        $query_pre="INSERT into foto values(null,".$id.",'".$plik."','".$opis."');";
        $typy_tmp=mysql_query($query_pre);
        $redir_link="index.php?action=show_fish&id=".$id;
        $this->redirect($redir_link);
    }

}

function dodaj_foto2($id,$link)
{

    if (strpos($link,'galeria.klub-malawi.pl'))
    {
        $this->sql->query('SET CHARACTER SET utf8;');
        $curl = curl_init();
	curl_setopt($curl, CURLOPT_URL, "$link");
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
        $strona = curl_exec($curl);
        curl_close($curl);
                
        $pos_start1 = strpos($strona, '"picsemi"');
        $pos_start2 = strpos($strona, 'src=".', $pos_start1)+6;
        $pos_end2 = strpos($strona, '"', $pos_start2);
        $plik = substr($strona,$pos_start2+1,$pos_end2-$pos_start2-1); 
//	echo $plik;
    
        $pos_start1 = strpos($strona, 'title"')+7;
//        $pos_start2 = strpos($strona, '<h2>', $pos_start1);
        $pos_end1 = strpos($strona, '<', $pos_start1);
        $opis = substr($strona,$pos_start1,$pos_end1-$pos_start1);
//    echo $opis;
//        break;
        $query_pre="INSERT into foto values(null,".$id.",'".$plik."','".$opis."');";
//	echo $query_pre;	
        $typy_tmp=mysql_query($query_pre);
        
	if (mysql_errno()) 
	{
	    $error = "\nBłąd MySQL ".mysql_errno().": ".mysql_error()."\nPrzy wykonaniu zapytania:\n".$query_pre."\n"; 
    	    $this->raport($id,$error);
	}
	else
	{
	    $redir_link="index.php?action=show_fish&id=".$id;
    	    $this->redirect($redir_link);
	}
    }

}

function wyloguj() 
{
    session_start();
    session_unset();
    session_destroy();
}

function zaloguj($login,$haslo) 
{

      // error_reporting(E_ALL);
      session_start();
      
      $user=urlencode($login);                                                                                                                                                                                 
      $pass=urlencode($haslo);                                                                                                                                                                                 
      $pass=base64_encode($pass);                                                                                                                                                                                          
		      
      $curl = curl_init();
      $url="http://baza.klub-malawi.pl/2.php?user=".$user."&pass=".$pass;
    //    echo $url."<BR>";
	      $data = array('user' => $user, 'pass' => $pass);
	          curl_setopt($curl, CURLOPT_POST, 1);
	      curl_setopt($curl, CURLOPT_POSTFIELDS, $data);
	          curl_setopt($curl, CURLOPT_URL, $url);
	      curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
	      $strona = curl_exec($curl);
	      curl_close($curl);   
//		echo $strona;
														      

      
      if($login=='gorol' and $haslo='qwe123_321ewq')
      {
                echo "Password verified! ";
	    $_SESSION['login']=$login;
//            $_SESSION['name']=$row[name];
	    $_SESSION['name']=$login;
//	    $_SESSION['admin']=$row[admin];

        $_SESSION['admin']=1;
            $_SESSION['ip']=$_SERVER['REMOTE_ADDR'];
            $PHPSESSID=session_id();
	    $PHPSESSNAME=session_name();
	    $this->redirect("index.php?".$PHPSESSNAME."=".$PHPSESSID);
      }
      
      /*
      // mysql connection
      $this->sql->query('SET CHARACTER SET utf8;');
      $this->sql->query('SET names utf8;');
      
      $query_pre="select id,login,name,passwd,admin from users where deleted=0 and login='".$login."' ;";
      $row=$this->sqlQ($query_pre);
      $row = $row[0];

      if (crypt($haslo, $row[passwd]) == $row[passwd])
*/
    if ($strona)
      {
            echo "Password verified! ";
//            $_SESSION['login']=$row[login];
	    $_SESSION['login']=$login;
//            $_SESSION['name']=$row[name];
	    $_SESSION['name']=$login;
//	    $_SESSION['admin']=$row[admin];

	    //ma konto
	    if ($strona=='1')
	    {
		$_SESSION['admin']=0;
	    }

	    //klubowicz
	    if ($strona=='2')
	    {
		$_SESSION['klubowicz']=1;
	    }
	    
	    //moderator bazy ryb
	    if ($strona=='3')
	    {
		$_SESSION['admin']=1;
	    }
	    
            $_SESSION['ip']=$_SERVER['REMOTE_ADDR'];
            $PHPSESSID=session_id();
	    $PHPSESSNAME=session_name();
	    
//	    $query_pre="update users set lastlogindate='".time()."' where deleted=0 and login='".$login."' ;";
//	    $tmp=mysql_query($query_pre);

//	    $query_pre="update users set lastloginip='".$_SERVER['REMOTE_ADDR']."' where deleted=0 and login='".$login."' ;";
//	    $tmp=mysql_query($query_pre);
	    
	    $this->redirect("index.php?".$PHPSESSNAME."=".$PHPSESSID);
      }
      else
      {
	    echo "LOGIN FAILED";
	    
//	    $query_pre="update users set failedlogindate='".time()."' where deleted=0 and login='".$login."' ;";
//	    $tmp=mysql_query($query_pre);	    

//	    $query_pre="update users set failedloginip='".$_SERVER['REMOTE_ADDR']."' where deleted=0 and login='".$login."' ;";
//	    $tmp=mysql_query($query_pre);
	    
	    sleep(2);
//	    $this->redirect("login.php");
      }
}

function raport($id,$error) 
{
      // error_reporting(E_ALL);
      session_start();
      // mysql connection

      $this->tpl->assign('id', $id);
      $this->tpl->assign('error', $error);
      //wyswietlenie formatki dodania zdjecia
      $this->tpl->display('raport.tpl');

}


function raport_wyslij($id,$tresc,$nick) 
{
      // error_reporting(E_ALL);
      session_start();
      // mysql connection


$tresc = wordwrap($tresc, 70);

// Send
//echo "mail('jczarniak@jarsat.pl', 'Raport', $tresc);";


require_once('Rmail.php');
    
$mail = new Rmail();
    
/**
* Set the from address of the email
*/
$mail->setFrom('Zgłoszenie.błędu <jczarniak@jarsat.pl>');

/**
* Set the subject of the email
*/
$mail->setSubject('Zgłoszenie błedu w bazie');
	        
/**
    * Set high priority for the email. This can also be:
    * high/normal/low/1/3/5
*/
$mail->setPriority('normal');
/**
    * Set the text of the Email
*/

$link="http://".$_SERVER['SERVER_NAME']."/index.php?action=show_fish&id=".$id;
$mail->setText($link.'   '.$nick.' ==> '.$tresc);
								    
/**
    * Set the HTML of the email. Any embedded images will be automatically found as long as you have added them
    * using addEmbeddedImage() as below.
*/
//$mail->setHTML('<b>Sample HTML</b> <img src="background.gif">');
								        
/**
    * Set the delivery receipt of the email. This should be an email address that the receipt should be sent to.
    * You are NOT guaranteed to receive this receipt - it is dependent on the receiver.
*/

$mail->setReceipt('jczarniak@jarsat.pl');
	    
/**
    * Add an embedded image. The path is the file path to the image.
*/
//$mail->addEmbeddedImage(new fileEmbeddedImage('background.gif'));
/**
    * Add an attachment to the email.
    */
//$mail->addAttachment(new fileAttachment('example.zip'));

/**
    * Send the email. Pass the method an array of recipients.
*/
$address = 'jczarniak@jarsat.pl';
$result  = $mail->send(array($address));


echo "Zgłoszenie zostało wysłane";
sleep (2);


//echo "Email has been sent to ".$address."<BR>";
//echo" Result: ".var_dump($result)."<BR>";
//print_r($result);

//break;

}


function moderacja($login,$admin)
{
      if ($login && $admin)
      {
            session_start();
            // mysql connection
            $this->sql->query('SET CHARACTER SET utf8;');
            $this->sql->query('SET names utf8;');
            $query_pre="select * from gatunki_moderacja";
            $gatunki_moderacja_tmp=mysql_query($query_pre);
            
            while ($row = mysql_fetch_assoc($gatunki_moderacja_tmp))
            {    
                  $gatunki_moderacja[]=$row;
                  
                  
                  $query_pre="select * from gatunki where id='".$row[id]."';";
                  $gatunki_tmp=mysql_query($query_pre);
                  $row = mysql_fetch_assoc($gatunki_tmp);
                  $gatunki_moderacja[]=$row;
                  $gatunki_moderacja[]='';
            }
            $this->tpl->assign('gatunki_moderacja', $gatunki_moderacja);
            $this->tpl->display('moderacja.tpl');
      }
      else
      echo "Fatal error: Call to undefined method Guestbook::moderacja() in /home/www/baza.jarsat.pl/index.php  on line 750";
}

function moderacja_odrzuc($id_mod)
{
      session_start();
      // mysql connection
      $this->sql->query('SET CHARACTER SET utf8;');
      $this->sql->query('SET names utf8;');
      $query_pre="delete from gatunki_moderacja where id_mod='".$id_mod."';";
      //echo $query_pre;
      mysql_query($query_pre) or die("Zapytanie niepoprawne");
      //break;
}

function moderacja_akceptuj($id_mod,$id)
{
      session_start();
      // mysql connection
      $this->sql->query('SET CHARACTER SET utf8;');
      $this->sql->query('SET names utf8;');
      $query_pre="DELETE FROM gatunki where id=".$id.";";
      mysql_query($query_pre) or die("Zapytanie niepoprawne");
      $query_pre="INSERT INTO gatunki SELECT id, typ ,nazwa ,nazwa_powsz ,pochodzenie ,srodowisko ,dieta ,plec ,rozmnazanie ,temperament ,widoczny_temperament ,wielkosc ,temperatura,temperatura_max ,ph ,twardosc ,trudnosc 
                  FROM gatunki_moderacja where id_mod='".$id_mod."';";
      mysql_query($query_pre) or die("Zapytanie niepoprawne");
      $query_pre="DELETE FROM gatunki_moderacja where id_mod='".$id_mod."';";
      //echo $query_pre;
      mysql_query($query_pre) or die("Zapytanie niepoprawne");
      //break;
      
}


function dodaj_komentarz($name,$email,$history,$return)
{
	include("mods/komentarze/settings.php");
	if ($name and ($email or $allow_no_email == "on") and $history and $return)
	{
		/////////////////////
		
		$_SESSION['the_name'] = $name;
		$_SESSION['the_email'] = $email;
		$_SESSION['the_history'] = $history;
		
		//vars
		$name = (string)$name;
		$email = (string)$email;
		$history = (string)$history;
		$ip = (string)$ip;
		$return = (string)$return;
		
		/////////////////
				/*check lenghts*/
					$name_lenght = strlen($name);
					$email_lenght = strlen($email);
					$history_lenght = strlen($history);
						if ($name_lenght > $max_name or $email_lenght > $max_email or $history_lenght > $max_history)
						{
							if ($show_error_messages == "on") $_SESSION['lenght'] = "on";
							header("location: index.php?action=show_fish&id=".$return);
							die("too long name");
						}
				
				/*check spam*/
				if ($allow_urls == "off")
				{
					$findme   = array('www', 'http', '.com', '.org', '.net', '.ly', '.es', '.cat', '.ar', '.tv', '[dot]');
					
					/*cheekings*/
						$pos = strpos($history, $findme[0]);
						$pos2 = strpos($history, $findme[1]);
						$pos3 = strpos($history, $findme[2]);
						$pos4 = strpos($history, $findme[3]);
						$pos5 = strpos($history, $findme[4]);
						$pos6 = strpos($history, $findme[5]);
						$pos7 = strpos($history, $findme[6]);
						$pos8 = strpos($history, $findme[7]);
						$pos9 = strpos($history, $findme[8]);
						$pos10 = strpos($history, $findme[9]);
						$pos11 = strpos($history, $findme[10]);
					if (($pos or $pos2 or $pos3 or $pos4 or $pos5 or $pos6 or $pos7 or $pos8 or $pos9 or $pos10 or $pos11) === true)
					{
						if ($show_error_messages == "on") $_SESSION['spam'] = "on";
						header("location: index.php?action=show_fish&id=".$return);
						die("no spaaaam");
					}
				
				}
		
				
		//we check if the written email is correct
		//$check_email = strpos($email, '@');		//find the @ char
		if ($allow_no_email == "on")
		{
		    $check_email = 1;
		}
		else
		{
		    $check_email = strpos($email, '@');		//find the @ char
		}

			if ($check_email === false)
			{
				if ($show_error_messages == "on") $_SESSION['email'] = "on";
				header("location: index.php?action=show_fish&id=".$return);
			}
			else
			{
					/*we replace < and > in the message, name and history*/
						$marks = array("<", ">");
						$replaced = array("&lt;", "&gt;");
							$new_name = str_replace($marks, $replaced, $name);
							$new_history = str_replace($marks, $replaced, $history);
				
				
				/*population of the db*/
				$date = date("d/m/Y");
				$ip = $_SERVER['REMOTE_ADDR'];
				
				mysql_query("INSERT INTO ".$db_table." VALUES ('".$new_name."', '".$email."', '".$new_history."', '".$ip."', '".$date."', '".$return."', '')") 
				or die('error trying to populate the db');
				
				if ($show_error_messages == "on") $_SESSION['published'] = "yes";
				/*get back*/
				header("location: index.php?action=show_fish&id=".$return);
			}
	
	}
	else
	{
		
		$_SESSION['fields'] = "on";
		header("location: index.php?action=show_fish&id=".$return);
	}

}


function logout() 
{
    session_start();
    session_unset();
    session_destroy();
}


function sortuj($arg,$order)
{
    session_start();
    $_SESSION['sort_arg']=$arg;
    $_SESSION['sort_order']=$order;
    if ($order=='asc'){$_SESSION['sort_unorder']='desc';}
    else{$_SESSION['sort_unorder']='asc';}
	
}


function edytuj_opis_show($id)
{

	    // DANE
	    $this->sql->query('SET CHARACTER SET utf8;');

            $query_pre=" 
	    SELECT * 
	    FROM foto f
	    where f.id=".$id." ;";
            $dane=$this->sqlQ($query_pre);


//print_r($dane);
//break;
	    $opis = $dane[0][foto_desc];

//      $this->tpl->debugging = true;
//      $this->tpl->assign('error', $this->error);

    	    $this->tpl->assign('id', $id);
    	    $this->tpl->assign('opis', $opis);
	    $this->tpl->display('show_edytuj_opis.tpl');
}

function edytuj_opis($id,$opis)
{

	    // DANE
	    $this->sql->query('SET CHARACTER SET utf8;');

            $query_pre=" 
	    UPDATE foto f set f.foto_desc='".$opis."'
	    where f.id=".$id." ;";
	    //echo $query_pre;
	    $tmp=mysql_query($query_pre);

    echo '<SCRIPT LANGUAGE="JavaScript">
	    window.opener.location.href = window.opener.location.href;
	    self.close();
	  </script>';
    
//print_r($dane);
//break;

//      $this->tpl->debugging = true;
//      $this->tpl->assign('error', $this->error);

}





}

?>
